gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
(function preloadTransform() {
  window.addEventListener("load", function (event) {
    document.body.classList.add("loaded");
  });
})();

(function gsapMatchMedia() {
  ScrollTrigger.matchMedia({
    all: function () {
      function getSamePageAnchor(link) {
        if (
          link.protocol !== window.location.protocol ||
          link.host !== window.location.host ||
          link.pathname !== window.location.pathname ||
          link.search !== window.location.search
        ) {
          return false;
        }

        return link.hash;
      }
      function scrollToHash(hash, e) {
        const elem = hash ? document.querySelector(hash) : false;
        if (elem) {
          if (e) e.preventDefault();
          gsap.to(window, { duration: 0, scrollTo: elem, ease: "power2" });
        }
      }
      document.querySelectorAll("a[href]").forEach((a) => {
        a.addEventListener("click", (e) => {
          scrollToHash(getSamePageAnchor(a), e);
        });
      });
      scrollToHash(window.location.hash);

      const boxes = gsap.utils.toArray(".gs-anim");
      boxes.forEach((box) => {
        gsap.from(box, {
          yPercent: 20,
          opacity: 0,
          duration: 1,
          scrollTrigger: {
            trigger: box,
            start: "top 90%",
            end: "center 50%",
          },
        });
      });

      const tlProjectsOdd = gsap.utils.toArray(".amenities-odd");
      tlProjectsOdd.forEach((elem) => {
        gsap.from(elem, {
          xPercent: -30,
          duration: 1.5,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });

      const tlProjectsEven = gsap.utils.toArray(".amenities-even");
      tlProjectsEven.forEach((elem) => {
        gsap.from(elem, {
          xPercent: 30,
          duration: 1.5,
          opacity: 0,
          scrollTrigger: {
            trigger: elem,
          },
        });
      });
      gsap.from(".about-brochure__img", {
        y: 400,
        x: -200,
        scrollTrigger: {
          trigger: ".about-brochure",
          start: "top 100%",
          end: "center 10%",
          scrub: 1,
        },
      });
      gsap.to(".detail-parallax-item-header", {
        scrollTrigger: {
          trigger: ".detail-parallax-item-header",
        },
        className: "detail-parallax-item-header active",
        delay: 1,
      });

      gsap.to(".detail-parallax-item-footer", {
        scrollTrigger: {
          trigger: ".detail-parallax-item-footer",
        },
        delay: 15,
        className: "detail-parallax-item-footer active",
      });
    },
    // 2500 - 993
    "(max-width: 2500px) and (min-width: 993px)": function () {
      var tlLocation = gsap.timeline({
        scrollTrigger: {
          trigger: ".location",
          start: "top top",
          end: "bottom bottom",
          scrub: true,
          pin: ".location__container",
        },
      });

      tlLocation.to(
        ".location__box-1 .location__even",
        { yPercent: 100, duration: 1 },
        "<"
      );
      tlLocation.to(
        ".location__box-1 .location__odd",
        { yPercent: -100, duration: 1 },
        "<"
      );
      tlLocation.to(
        ".location__box-2 .location__even",
        { yPercent: -100, duration: 1 },
        "<"
      );
      tlLocation.to(
        ".location__box-2 .location__odd",
        { yPercent: 100, duration: 1 },
        "<"
      );
    },
    // 992 - 769
    "(max-width: 992px) and (min-width: 769px)": function () {},
    // 768 - 577
    "(max-width: 768px) and (min-width: 577px)": function () {},
    // 576 - 320
    "(max-width: 576px) and (min-width: 320px)": function () {},
  });
})();
